#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

int main() {
    // Unos dimenzija matrice i podmatrica
    int N, M, K, L;
    std::cin >> N >> M >> K >> L;

    // Unos niza A
    std::vector<int> A(N * M);
    for (int i = 0; i < N * M; i++) {
        std::cin >> A[i];
    }

    // Konverzija niza A u matricu
    std::vector<std::vector<int>> matrixA(N, std::vector<int>(M));
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            matrixA[i][j] = A[i * M + j];
        }
    }

    // Pronalaženje najveceg broja
    int max = INT_MIN;
    int maxRowIndex = 0;
    int maxColIndex = 0;
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            if (matrixA[i][j] > max) {
                max = matrixA[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }

    // Premestanje najveceg broja u središnju matricu
    int tmp = matrixA[N / 2][M / 2];
    matrixA[N / 2][M / 2] = max;
    matrixA[maxRowIndex][maxColIndex] = tmp;

    // Sortiranje svakog reda matrice tako da je najveci broj na poziciji M/2
    std::vector<std::vector<int>> sortedMatrix(N, std::vector<int>(M));
    for (int i = 0; i < N; i++) {
        std::sort(matrixA[i].begin(), matrixA[i].end());
        int idx = M / 2;
        for (int j = 0; j < M; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % M];
        }
    }

    // Podela matrice na podmatrice dimenzija KxL
    std::vector<std::vector<std::vector<int>>> submatrices(N - K + 1, std::vector<std::vector<int>>(M - L + 1, std::vector<int>(K * L)));
    for (int i = 0; i < N - K + 1; i++) {
        for (int j = 0; j < M - L + 1; j++) {
            for (int k = 0; k < K; k++) {
                for (int l = 0; l < L; l++) {
                    submatrices[i][j][k * L + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

    // Sabiranje svih podmatrica
    int totalSum = 0;
    for (int i = 0; i < N - K + 1; i++) {
        for (int j = 0; j < M - L + 1; j++) {
            for (int val : submatrices[i][j]) {
                totalSum += val;
            }
        }
    }

    std::cout << totalSum << std::endl;

    return 0;
}